/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.junit.jupiter.api.Test;

public class FileMulticastDeleteTest
extends ContextTestSupport {
    @Test
    public void testFileMulticastDelete() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Got Hello World"});
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((MulticastDefinition)this.from(FileMulticastDeleteTest.this.fileUri("?delete=true&initialDelay=0&delay=10")).multicast((AggregationStrategy)new UseLatestAggregationStrategy()).shareUnitOfWork().to(new String[]{"direct:foo", "direct:bar"})).end().convertBodyTo(String.class).to("mock:result");
                ((AggregateDefinition)((AggregateDefinition)((RouteDefinition)this.from("direct:foo").to("log:foo")).aggregate((Expression)this.header("CamelFileName"), (AggregationStrategy)new MyFileAggregator()).completionTimeout(100L).convertBodyTo(String.class)).to("mock:foo")).end();
                ((RouteDefinition)((RouteDefinition)this.from("direct:bar").to("log:bar")).convertBodyTo(String.class)).to("mock:bar");
            }
        };
    }

    public static class MyFileAggregator
    implements AggregationStrategy {
        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            String data = (String)newExchange.getIn().getBody(String.class);
            newExchange.getIn().setBody((Object)("Got " + data));
            return newExchange;
        }
    }
}

