/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.DefaultMessage;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileMoveWithInMessageTest
extends ContextTestSupport {
    @Test
    public void testMove() {
        String uri = this.fileUri();
        this.template.sendBodyAndHeader(uri, (Object)"Hello World1", "CamelFileName", (Object)"hello1.txt");
        this.template.sendBodyAndHeader(uri, (Object)"Hello World2", "CamelFileName", (Object)"hello2.txt");
        this.template.sendBody("seda:triggerIn", (Object)"");
        File file1 = new File(this.testDirectory().toFile(), "archive/hello1.txt");
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).untilAsserted(() -> Assertions.assertTrue((boolean)file1.exists(), (String)"The file should exist in the archive folder"));
        File file2 = new File(this.testDirectory().toFile(), "archive/hello2.txt");
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).untilAsserted(() -> Assertions.assertTrue((boolean)file2.exists(), (String)"The file should exist in the archive folder"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("seda:triggerIn").pollEnrich(FileMoveWithInMessageTest.this.fileUri() + "?move=archive")).pollEnrich(FileMoveWithInMessageTest.this.fileUri() + "?move=archive")).process((Processor)new TestProcessor());
            }
        };
    }

    private static class TestProcessor
    implements Processor {
        private TestProcessor() {
        }

        public void process(Exchange exchange) {
            DefaultMessage msg = new DefaultMessage(exchange);
            msg.setBody(exchange.getIn().getBody());
            msg.setHeaders(exchange.getIn().getHeaders());
            exchange.setIn((Message)msg);
        }
    }
}

