/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileMoveAndMoveFailedIssueTest
extends ContextTestSupport {
    @Test
    public void testMove() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedFileExists(this.testFile("input.bak/somedate/hello.txt"));
        this.template.sendBodyAndHeader(this.fileUri("input"), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testMoveFailed() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedFileExists(this.testFile("input.err/somedate/bomb.txt"));
        this.template.sendBodyAndHeader(this.fileUri("input"), (Object)"Kaboom", "CamelFileName", (Object)"bomb.txt");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((RouteDefinition)this.fromF("file://%s/input?move=${file:parent}.bak/somedate/${file:onlyname}&moveFailed=${file:parent}.err/somedate/${file:onlyname}&initialDelay=0&delay=10", new Object[]{FileMoveAndMoveFailedIssueTest.this.testDirectory().toAbsolutePath()}).convertBodyTo(String.class)).filter(this.body().contains((Object)"Kaboom")).throwException((Exception)new IllegalArgumentException("Forced"))).end().to("mock:result");
            }
        };
    }
}

