/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileFilter;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;

public class FileMarkerFileRecursiveFilterDeleteOldLockFilesTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myFilter", (Object)new MyFileFilter());
        return jndi;
    }

    @Test
    public void testDeleteOldLockOnStartup() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        mock.expectedBodiesReceived(new Object[]{"Bye World", "Hi World"});
        ((MockValueBuilder)mock.message(0).header("CamelFileNameOnly")).isEqualTo((Object)"bye.txt");
        ((MockValueBuilder)mock.message(1).header("CamelFileNameOnly")).isEqualTo((Object)"hi.txt");
        mock.expectedFileExists(this.testFile("bar/davs.txt"));
        mock.expectedFileExists(this.testFile("bar/davs.txt.camelLock"));
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"locked", "CamelFileName", (Object)"hello.txt.camelLock");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        this.template.sendBodyAndHeader(this.fileUri("foo"), (Object)"locked", "CamelFileName", (Object)"gooday.txt.camelLock");
        this.template.sendBodyAndHeader(this.fileUri("foo"), (Object)"Hi World", "CamelFileName", (Object)"hi.txt");
        this.template.sendBodyAndHeader(this.fileUri("bar"), (Object)"locked", "CamelFileName", (Object)"davs.txt.camelLock");
        this.template.sendBodyAndHeader(this.fileUri("bar"), (Object)"Davs World", "CamelFileName", (Object)"davs.txt");
        this.context.getRouteController().startRoute("foo");
        this.assertMockEndpointsSatisfied();
        FileMarkerFileRecursiveFilterDeleteOldLockFilesTest.assertFileNotExists(this.testFile("hello.txt..camelLock"));
        FileMarkerFileRecursiveFilterDeleteOldLockFilesTest.assertFileNotExists(this.testFile("foo/hegooddayllo.txt..camelLock"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileMarkerFileRecursiveFilterDeleteOldLockFilesTest.this.fileUri("?initialDelay=0&delay=10&recursive=true&sortBy=file:name&filter=#myFilter")).routeId("foo").autoStartup(false).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }

    private static final class MyFileFilter
    implements GenericFileFilter<File> {
        private MyFileFilter() {
        }

        public boolean accept(GenericFile<File> file) {
            return !file.isDirectory() || !"bar".equals(file.getFileName());
        }
    }
}

