/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileMarkerFileRecursiveFilterDeleteOldLockFilesIncludeTest
extends ContextTestSupport {
    @Test
    public void testDeleteOldLockOnStartup() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        mock.expectedBodiesReceived(new Object[]{"Bye World", "Hi World"});
        ((MockValueBuilder)mock.message(0).header("CamelFileNameOnly")).isEqualTo((Object)"bye.txt");
        ((MockValueBuilder)mock.message(1).header("CamelFileNameOnly")).isEqualTo((Object)"gooday.txt");
        mock.expectedFileExists(this.testFile("bar/davs.txt"));
        mock.expectedFileExists(this.testFile("bar/davs.txt.camelLock"));
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"locked", "CamelFileName", (Object)"hello.txt.camelLock");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        this.template.sendBodyAndHeader(this.fileUri("foo"), (Object)"locked", "CamelFileName", (Object)"gooday.txt.camelLock");
        this.template.sendBodyAndHeader(this.fileUri("foo"), (Object)"Hi World", "CamelFileName", (Object)"gooday.txt");
        this.template.sendBodyAndHeader(this.fileUri("bar"), (Object)"locked", "CamelFileName", (Object)"davs.txt.camelLock");
        this.template.sendBodyAndHeader(this.fileUri("bar"), (Object)"Davs World", "CamelFileName", (Object)"davs.txt");
        this.context.getRouteController().startRoute("foo");
        this.assertMockEndpointsSatisfied();
        FileMarkerFileRecursiveFilterDeleteOldLockFilesIncludeTest.assertFileNotExists(this.testFile("hello.txt..camelLock"));
        FileMarkerFileRecursiveFilterDeleteOldLockFilesIncludeTest.assertFileNotExists(this.testFile("foo/hegooddayllo.txt..camelLock"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileMarkerFileRecursiveFilterDeleteOldLockFilesIncludeTest.this.fileUri("?initialDelay=0&delay=10&recursive=true&sortBy=file:name&include=.*(hello.txt|bye.txt|gooday.txt)$")).routeId("foo").autoStartup(false).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

