/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileMarkerFileRecursiveDoNotDeleteOldLockFilesTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME_1 = "hello" + String.valueOf(UUID.randomUUID()) + ".txt";
    private static final String TEST_FILE_NAME_2 = "gooday" + String.valueOf(UUID.randomUUID()) + ".txt";
    private static final String TEST_FILE_NAME_3 = "new" + String.valueOf(UUID.randomUUID()) + ".txt";

    @Test
    public void testDeleteOldLockOnStartup() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"New World"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"locked", "CamelFileName", (Object)(TEST_FILE_NAME_1 + ".camelLock"));
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME_1);
        this.template.sendBodyAndHeader(this.fileUri("foo"), (Object)"locked", "CamelFileName", (Object)(TEST_FILE_NAME_2 + ".camelLock"));
        this.template.sendBodyAndHeader(this.fileUri("foo"), (Object)"Goodday World", "CamelFileName", (Object)TEST_FILE_NAME_2);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"New World", "CamelFileName", (Object)TEST_FILE_NAME_3);
        this.context.getRouteController().startRoute("foo");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileMarkerFileRecursiveDoNotDeleteOldLockFilesTest.this.fileUri("?initialDelay=0&delay=10&readLock=markerFile&readLockDeleteOrphanLockFiles=false&recursive=true")).routeId("foo").autoStartup(false).convertBodyTo(String.class)).to(new String[]{"log:result", "mock:result"});
            }
        };
    }
}

