/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileMarkerFileRecursiveDeleteOldLockFilesTest
extends ContextTestSupport {
    @Test
    public void testDeleteOldLockOnStartup() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        mock.expectedBodiesReceived(new Object[]{"Bye World", "Hi World"});
        ((MockValueBuilder)mock.message(0).header("CamelFileNameOnly")).isEqualTo((Object)"bye.txt");
        ((MockValueBuilder)mock.message(1).header("CamelFileNameOnly")).isEqualTo((Object)"hi.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"locked", "CamelFileName", (Object)"hello.txt.camelLock");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        this.template.sendBodyAndHeader(this.fileUri("foo"), (Object)"locked", "CamelFileName", (Object)"gooday.txt.camelLock");
        this.template.sendBodyAndHeader(this.fileUri("foo"), (Object)"Hi World", "CamelFileName", (Object)"hi.txt");
        this.context.getRouteController().startRoute("foo");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileMarkerFileRecursiveDeleteOldLockFilesTest.this.fileUri("?initialDelay=0&delay=10&recursive=true&sortBy=file:name")).routeId("foo").autoStartup(false).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

