/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileLanguageCBRTest
extends ContextTestSupport {
    @Test
    public void testTxt() throws Exception {
        this.getMockEndpoint("mock:txt").expectedMessageCount(1);
        this.getMockEndpoint("mock:dat").expectedMessageCount(0);
        this.getMockEndpoint("mock:other").expectedMessageCount(0);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testDat() throws Exception {
        this.getMockEndpoint("mock:txt").expectedMessageCount(0);
        this.getMockEndpoint("mock:dat").expectedMessageCount(1);
        this.getMockEndpoint("mock:other").expectedMessageCount(0);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Bye World", "CamelFileName", (Object)"bye.dat");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testOther() throws Exception {
        this.getMockEndpoint("mock:txt").expectedMessageCount(0);
        this.getMockEndpoint("mock:dat").expectedMessageCount(0);
        this.getMockEndpoint("mock:other").expectedMessageCount(1);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hi World", "CamelFileName", (Object)"hi.foo");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((RouteDefinition)this.from(FileLanguageCBRTest.this.fileUri("?delete=true&initialDelay=0&delay=10")).convertBodyTo(String.class)).choice().when().simple("${file:ext} == 'txt'")).to("mock:txt")).when().simple("${file:ext} == 'dat'")).to("mock:dat")).otherwise().to("mock:other");
            }
        };
    }
}

