/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;

@DisabledOnOs(architectures={"s390x"}, disabledReason="This test does not run reliably on s390x (see CAMEL-21438)")
public class FileKeepLastModifiedTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME = "hello." + String.valueOf(UUID.randomUUID()) + ".txt";

    @Test
    public void testKeepLastModified() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from(FileKeepLastModifiedTest.this.fileUri("?noop=true&initialDelay=0&delay=10")).delay(10L).to(new String[]{FileKeepLastModifiedTest.this.fileUri("out?keepLastModified=true"), "mock:result"});
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        ((MockValueBuilder)mock.message(0).header("CamelFileLastModified")).isNotNull();
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.assertMockEndpointsSatisfied();
        long t1 = (Long)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getHeader("CamelFileLastModified", Long.TYPE);
        long t2 = this.testFile("out/" + TEST_FILE_NAME).toFile().lastModified();
        Assertions.assertEquals((long)t1, (long)t2, (String)"Timestamp should have been kept");
    }

    @Test
    public void testDoNotKeepLastModified() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from(FileKeepLastModifiedTest.this.fileUri("?noop=true&initialDelay=0&delay=10")).delay(10L).to(new String[]{FileKeepLastModifiedTest.this.fileUri("out?keepLastModified=false"), "mock:result"});
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        ((MockValueBuilder)mock.message(0).header("CamelFileLastModified")).isNotNull();
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.assertMockEndpointsSatisfied();
        long t1 = (Long)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getHeader("CamelFileLastModified", Long.TYPE);
        long t2 = this.testFile("out/" + TEST_FILE_NAME).toFile().lastModified();
        Assertions.assertNotSame((Object)t1, (Object)t2, (String)"Timestamp should NOT have been kept");
    }

    @Test
    public void testDoNotKeepLastModifiedIsDefault() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from(FileKeepLastModifiedTest.this.fileUri("?noop=true&initialDelay=0&delay=10")).delay(10L).to(new String[]{FileKeepLastModifiedTest.this.fileUri("out"), "mock:result"});
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        ((MockValueBuilder)mock.message(0).header("CamelFileLastModified")).isNotNull();
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.assertMockEndpointsSatisfied();
        long t1 = (Long)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getHeader("CamelFileLastModified", Long.TYPE);
        long t2 = this.testFile("out/" + TEST_FILE_NAME).toFile().lastModified();
        Assertions.assertNotSame((Object)t1, (Object)t2, (String)"Timestamp should NOT have been kept");
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }
}

