/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileIdempotentReadSameFileAgainTest
extends ContextTestSupport {
    public static final String FILE_QUERY = "?idempotent=false&move=../done&moveFailed=../error&preMove=working/${date:now:yyyyMMddHHmmssSSS}-${file:name}&readLock=none&initialDelay=0&delay=10";

    @Test
    public void testConsumeSameFileAgain() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World", "Foo"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"foo.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Foo", "CamelFileName", (Object)"bar.txt");
        this.assertMockEndpointsSatisfied();
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Bye World", "CamelFileName", (Object)"foo.txt");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileIdempotentReadSameFileAgainTest.this.fileUri(FileIdempotentReadSameFileAgainTest.FILE_QUERY)).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

