/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileExclusiveReadNoneStrategyTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(FileExclusiveReadNoneStrategyTest.class);

    protected RouteBuilder createRouteBuilder() {
        final String fileUrl = this.fileUri("slowfile?noop=true&initialDelay=0&delay=10&readLock=none");
        return new RouteBuilder(){

            public void configure() {
                this.from("seda:start").process((Processor)new MySlowFileProcessor());
                this.from(fileUrl + "&readLockTimeout=500").to("mock:result");
            }
        };
    }

    @Test
    public void testPollFileWhileSlowFileIsBeingWritten() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("seda:start", (Object)"Create the slow file");
        mock.assertIsSatisfied();
        String body = (String)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getBody(String.class);
        LOG.debug("Body is: {}", (Object)body);
        Assertions.assertFalse((boolean)body.endsWith("Bye World"), (String)"Should not wait and read the entire file");
    }

    private class MySlowFileProcessor
    implements Processor {
        private MySlowFileProcessor() {
        }

        public void process(Exchange exchange) throws Exception {
            LOG.info("Creating a slow file with no locks...");
            try (OutputStream fos = Files.newOutputStream(FileExclusiveReadNoneStrategyTest.this.testFile("slowfile/hello.txt"), new OpenOption[0]);){
                fos.write("Hello World".getBytes());
                for (int i = 0; i < 3; ++i) {
                    Thread.sleep(100L);
                    fos.write(("Line #" + i).getBytes());
                    LOG.info("Appending to slowfile");
                }
                fos.write("Bye World".getBytes());
            }
            LOG.info("... done creating slowfile");
        }
    }
}

