/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

public class FileExclusiveReadLockCopyTest
extends ContextTestSupport {
    public static final String FILE_QUERY = "?readLock=fileLock&initialDelay=0&delay=10";
    private static final String DEST = FileExclusiveReadLockCopyTest.class.getSimpleName();

    @Test
    @DisabledOnOs(value={OS.WINDOWS})
    public void testCopy() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        Path path = this.testFile(DEST + File.separator + "hello.txt");
        mock.expectedFileExists(path, "Hello World");
        this.template.sendBodyAndHeader(this.fileUri(FILE_QUERY), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(this::isFlushed);
        mock.assertIsSatisfied();
    }

    private boolean isFlushed() {
        Path path = this.testFile(DEST + File.separator + "hello.txt");
        return path.toFile().exists() && (long)"Hello World".length() == path.toFile().length();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileExclusiveReadLockCopyTest.this.fileUri(FileExclusiveReadLockCopyTest.FILE_QUERY)).to(FileExclusiveReadLockCopyTest.this.fileUri(DEST))).to("mock:result");
            }
        };
    }
}

