/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.camel.ContextTestSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FileEagerDeleteTargetFileTest
extends ContextTestSupport {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"world.txt");
    }

    @Test
    public void testEagerDeleteTargetFileTrue() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri("?tempFileName=inprogress-${file:name}&eagerDeleteTargetFile=true"), (Object)"Bye World", "CamelFileName", (Object)"world.txt");
        Path file = this.testFile("world.txt");
        Assertions.assertTrue((boolean)Files.exists(file, new LinkOption[0]), (String)"File should exist");
        Assertions.assertEquals((Object)"Bye World", (Object)new String(Files.readAllBytes(file)));
    }

    @Test
    public void testEagerDeleteTargetFileFalse() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri("?tempFileName=inprogress-${file:name}&eagerDeleteTargetFile=false"), (Object)"Bye World", "CamelFileName", (Object)"world.txt");
        Path file = this.testFile("world.txt");
        Assertions.assertTrue((boolean)Files.exists(file, new LinkOption[0]), (String)"File should exist");
        Assertions.assertEquals((Object)"Bye World", (Object)new String(Files.readAllBytes(file)));
    }

    @Test
    public void testEagerDeleteTargetFileDefault() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri("?tempFileName=inprogress-${file:name}"), (Object)"Bye World", "CamelFileName", (Object)"world.txt");
        Path file = this.testFile("world.txt");
        Assertions.assertTrue((boolean)Files.exists(file, new LinkOption[0]), (String)"File should exist");
        Assertions.assertEquals((Object)"Bye World", (Object)new String(Files.readAllBytes(file)));
    }
}

