/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.nio.charset.StandardCharsets;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.ObjectHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileConvertBodyToUTF8Test
extends ContextTestSupport {
    @Test
    public void testFileUTF8() throws Exception {
        byte[] body = "Hello Thai Elephant \u0e08".getBytes(StandardCharsets.UTF_8);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)body, "CamelFileName", (Object)"utf8.txt");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConvertBodyToUTF8Test.this.fileUri("?initialDelay=0&delay=10")).convertBodyTo(String.class, "UTF-8")).to("mock:result");
            }
        });
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.assertMockEndpointsSatisfied();
        byte[] data = (byte[])((Exchange)mock.getReceivedExchanges().get(0)).getIn().getBody(byte[].class);
        boolean same = ObjectHelper.equal((Object)body, (Object)data);
        Assertions.assertTrue((boolean)same, (String)"Should be same byte data");
    }
}

