/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.junit.jupiter.api.Test;

public class FileContentBasedRouterTest
extends ContextTestSupport {
    private void sendFiles() {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello London", "CamelFileName", (Object)"london.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello Paris", "CamelFileName", (Object)"paris.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello Copenhagen", "CamelFileName", (Object)"copenhagen.txt");
    }

    @Test
    public void testRouteLondon() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:london");
        mock.expectedMessageCount(1);
        ((MockValueBuilder)mock.message(0).body()).isInstanceOf(GenericFile.class);
        this.sendFiles();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRouteParis() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:paris");
        mock.expectedMessageCount(1);
        ((MockValueBuilder)mock.message(0).body()).isInstanceOf(GenericFile.class);
        this.sendFiles();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRouteOther() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:other");
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived("CamelFileName", (Object)"copenhagen.txt");
        ((MockValueBuilder)mock.message(0).body()).isInstanceOf(GenericFile.class);
        this.sendFiles();
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)this.from(FileContentBasedRouterTest.this.fileUri("?noop=true&initialDelay=0&delay=10")).choice().when(this.header("CamelFileName").isEqualTo((Object)"london.txt")).to("mock:london")).when(this.header("CamelFileName").isEqualTo((Object)"paris.txt")).to("mock:paris")).otherwise().to("mock:other");
            }
        };
    }
}

