/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ThreadsDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileConsumerThreadsInProgressIssueTest
extends ContextTestSupport {
    private final Map<String, Integer> duplicate = new HashMap<String, Integer>();
    private final SampleProcessor processor = new SampleProcessor(this.duplicate);

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ThreadsDefinition)((ThreadsDefinition)this.from(FileConsumerThreadsInProgressIssueTest.this.fileUri("?sortBy=file:name&delay=10&synchronous=false")).routeId("myRoute").autoStartup(false).threads(1, 10).maxQueueSize(0).convertBodyTo(String.class)).process((Processor)FileConsumerThreadsInProgressIssueTest.this.processor)).to(new String[]{"log:done", "mock:done"});
            }
        };
    }

    @Test
    public void testFileConsumerThreadsInProgressIssue() throws Exception {
        this.context.getShutdownStrategy().setTimeout(180L);
        MockEndpoint mock = this.getMockEndpoint("mock:done");
        int number = 2000;
        mock.expectedMessageCount(number);
        mock.expectsNoDuplicates((Expression)FileConsumerThreadsInProgressIssueTest.body());
        this.createManyFiles(number);
        this.context.getRouteController().startRoute("myRoute");
        mock.setResultWaitTime(180000L);
        mock.assertIsSatisfied();
        this.context.stop();
        int found = 0;
        this.log.info("=====================");
        this.log.info("Printing duplicates");
        for (Map.Entry<String, Integer> ent : this.duplicate.entrySet()) {
            Integer count = ent.getValue();
            if (count <= 1) continue;
            ++found;
            this.log.info("{} :: {}", (Object)ent.getKey(), (Object)count);
        }
        Assertions.assertEquals((int)0, (int)found, (String)"Should not contain duplicates");
    }

    private void createManyFiles(int number) throws Exception {
        Path dir = this.testDirectory();
        for (int i = 0; i < number; ++i) {
            String fileNamesSuffix = String.format("%04d", i);
            String pad = String.format("%04d%n", i);
            try (BufferedWriter writer = Files.newBufferedWriter(dir.resolve("newFile-" + fileNamesSuffix), new OpenOption[0]);){
                writer.write(pad);
                continue;
            }
        }
    }

    private class SampleProcessor
    implements Processor {
        private final Map<String, Integer> duplicate;

        public SampleProcessor(Map<String, Integer> duplicate) {
            this.duplicate = duplicate;
        }

        public void process(Exchange exchange) throws Exception {
            Integer integer = this.duplicate.get(exchange.getExchangeId());
            if (integer == null) {
                this.duplicate.put(exchange.getExchangeId(), 1);
            } else {
                Integer n = integer;
                integer = integer + 1;
                this.duplicate.put(exchange.getExchangeId(), integer);
            }
            FileConsumerThreadsInProgressIssueTest.this.log.info("Process called for-{}", (Object)exchange.getExchangeId());
            Thread.sleep(20L);
        }
    }
}

