/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.support.processor.idempotent.MemoryIdempotentRepository;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileConsumerTemplateIdempotentEagerTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testConsumerTemplate() throws Exception {
        this.context.start();
        String uri = this.fileUri() + "?noop=true";
        this.template.sendBodyAndHeader(uri, (Object)"one", "CamelFileName", (Object)"1.txt");
        this.template.sendBodyAndHeader(uri, (Object)"two", "CamelFileName", (Object)"2.txt");
        Exchange e1 = this.consumer().receive(uri, 5000L);
        Assertions.assertNotNull((Object)e1);
        String b1 = (String)e1.getMessage().getBody(String.class);
        Assertions.assertTrue(("one".equals(b1) || "two".equals(b1) ? 1 : 0) != 0, (String)("Should either be one or two, was: " + b1));
        this.consumer().doneUoW(e1);
        FileEndpoint fe = (FileEndpoint)this.context.getEndpoint(uri, FileEndpoint.class);
        MemoryIdempotentRepository repo = (MemoryIdempotentRepository)fe.getIdempotentRepository();
        Assertions.assertEquals((int)1, (int)repo.getCacheSize());
        Exchange e2 = this.consumer().receive(uri, 5000L);
        Assertions.assertNotNull((Object)e2);
        String b2 = (String)e2.getMessage().getBody(String.class);
        Assertions.assertTrue(("one".equals(b2) || "two".equals(b2) ? 1 : 0) != 0, (String)("Should either be one or two, was: " + b2));
        this.consumer().doneUoW(e2);
        Assertions.assertEquals((int)2, (int)repo.getCacheSize());
        Assertions.assertNotEquals((Object)b1, (Object)b2);
    }
}

