/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.support.RoutePolicySupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileConsumerSuspendTest
extends ContextTestSupport {
    @Test
    public void testConsumeSuspendFile() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesWaitTime();
        try (Stream<Path> list = Files.list(this.testDirectory());){
            long files = list.count();
            Assertions.assertEquals((long)1L, (long)files, (String)"The file should exists");
        }
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                MyPolicy myPolicy = new MyPolicy();
                ((RouteDefinition)((RouteDefinition)this.from(FileConsumerSuspendTest.this.fileUri("?maxMessagesPerPoll=1&delete=true&initialDelay=0&delay=10")).routePolicy(new RoutePolicy[]{myPolicy}).id("myRoute")).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }

    private static class MyPolicy
    extends RoutePolicySupport {
        private int counter;

        private MyPolicy() {
        }

        public void onExchangeDone(Route route, Exchange exchange) {
            if (this.counter++ == 0) {
                try {
                    super.stopConsumer(route.getConsumer());
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }
        }
    }
}

