/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FileConsumerStartingDirectoryMustHaveAccessTest
extends ContextTestSupport {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        File file1 = this.testDirectory("noAccess", true).toFile();
        Assumptions.assumeTrue((boolean)file1.setReadable(false));
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        File file1 = this.testDirectory("noAccess").toFile();
        file1.setReadable(true);
        super.tearDown();
    }

    @Test
    public void testStartingDirectoryMustHaveAccess() {
        Endpoint endpoint = this.context.getEndpoint(this.fileUri("noAccess?autoCreate=false&startingDirectoryMustExist=true&startingDirectoryMustHaveAccess=true"));
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> {
            Consumer c = endpoint.createConsumer(exchange -> {});
            c.start();
        }, (String)"Should have thrown an exception");
        Assertions.assertTrue((boolean)e.getCause().getMessage().startsWith("Starting directory permission denied"), (String)e.getMessage());
    }
}

