/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FileConsumerSkipDotFilesTest
extends ContextTestSupport {
    @BeforeEach
    void sendDotFile() {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"This is a dot file", "CamelFileName", (Object)".skipme");
    }

    @Test
    public void testSkipDotFiles() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        mock.setResultWaitTime(100L);
        mock.assertIsSatisfied();
    }

    @Test
    public void testSkipDotFilesWithARegularFile() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        mock.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumerSkipDotFilesTest.this.fileUri("?initialDelay=0&delay=10")).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

