/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ThreadPoolBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileConsumerSharedThreadPollTest
extends ContextTestSupport {
    private ScheduledExecutorService pool;

    @Test
    public void testSharedThreadPool() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        ((MockValueBuilder)mock.message(0).header("threadName")).isEqualTo(mock.message(1).header("threadName"));
        this.template.sendBodyAndHeader(this.fileUri("a"), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader(this.fileUri("b"), (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() throws Exception {
                FileConsumerSharedThreadPollTest.this.pool = new ThreadPoolBuilder((CamelContext)FileConsumerSharedThreadPollTest.this.context).poolSize(1).buildScheduled((Object)this, "MySharedPool");
                FileConsumerSharedThreadPollTest.this.context.getRegistry().bind("myPool", (Object)FileConsumerSharedThreadPollTest.this.pool);
                this.from(FileConsumerSharedThreadPollTest.this.fileUri("a?initialDelay=0&delay=10&scheduledExecutorService=#myPool")).routeId("a").to("direct:shared");
                this.from(FileConsumerSharedThreadPollTest.this.fileUri("b?initialDelay=0&delay=10&scheduledExecutorService=#myPool")).routeId("b").to("direct:shared");
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:shared").routeId("shared").convertBodyTo(String.class)).log("Get ${file:name} using ${threadName}")).process(new Processor(){

                    public void process(Exchange exchange) {
                        exchange.getIn().setHeader("threadName", (Object)Thread.currentThread().getName());
                    }
                })).to("mock:result");
            }
        };
    }
}

