/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.component.file.FileConsumerSharedThreadPollTest;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.junit.jupiter.api.Test;

public class FileConsumerSharedThreadPollStopRouteTest
extends FileConsumerSharedThreadPollTest {
    @Override
    @Test
    public void testSharedThreadPool() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        ((MockValueBuilder)mock.message(0).header("threadName")).isEqualTo(mock.message(1).header("threadName"));
        this.template.sendBodyAndHeader(this.fileUri("a"), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader(this.fileUri("b"), (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        this.assertMockEndpointsSatisfied();
        this.context.getRouteController().stopRoute("a");
        this.resetMocks();
        mock.expectedBodiesReceived(new Object[]{"Bye World 2"});
        mock.expectedFileExists(this.testFile("a/hello2.txt"));
        this.template.sendBodyAndHeader(this.fileUri("a"), (Object)"Hello World 2", "CamelFileName", (Object)"hello2.txt");
        this.template.sendBodyAndHeader(this.fileUri("b"), (Object)"Bye World 2", "CamelFileName", (Object)"bye2.txt");
        this.assertMockEndpointsSatisfied();
        this.resetMocks();
        mock.expectedBodiesReceived(new Object[]{"Hello World 2"});
        this.context.getRouteController().startRoute("a");
        this.assertMockEndpointsSatisfied();
    }
}

