/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.consumer.DirectoryEntriesResumeAdapter;
import org.apache.camel.component.file.consumer.FileResumeAdapter;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.resume.TransientResumeStrategy;
import org.apache.camel.resume.ResumeAdapter;
import org.apache.camel.support.resume.Resumables;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

@DisplayName(value="Tests whether file consumer works with the resume strategy")
public class FileConsumerResumeStrategyTest
extends ContextTestSupport {
    private final TestFileSetResumeAdapter adapter = new TestFileSetResumeAdapter();

    private static Map<String, Object> headerFor(int num) {
        String name = num + ".txt";
        return Map.of("CamelFileName", name);
    }

    @DisplayName(value="Tests whether it can resume processing of directory entries")
    @Test
    public void testResume() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"3", "4", "5", "6"});
        this.template.sendBodyAndHeaders(this.fileUri("resume"), (Object)"0", FileConsumerResumeStrategyTest.headerFor(0));
        this.template.sendBodyAndHeaders(this.fileUri("resume"), (Object)"1", FileConsumerResumeStrategyTest.headerFor(1));
        this.template.sendBodyAndHeaders(this.fileUri("resume"), (Object)"2", FileConsumerResumeStrategyTest.headerFor(2));
        this.template.sendBodyAndHeaders(this.fileUri("resume"), (Object)"3", FileConsumerResumeStrategyTest.headerFor(3));
        this.template.sendBodyAndHeaders(this.fileUri("resume"), (Object)"4", FileConsumerResumeStrategyTest.headerFor(4));
        this.template.sendBodyAndHeaders(this.fileUri("resume"), (Object)"5", FileConsumerResumeStrategyTest.headerFor(5));
        this.template.sendBodyAndHeaders(this.fileUri("resume"), (Object)"6", FileConsumerResumeStrategyTest.headerFor(6));
        this.assertMockEndpointsSatisfied();
        Assertions.assertTrue((boolean)this.adapter.resumedCalled, (String)"The resume set should have resumables in this scenario");
    }

    private void setOffset(Exchange exchange) {
        String body = (String)exchange.getMessage().getBody(String.class);
        if (body != null) {
            Integer num = Integer.valueOf(body);
            exchange.getMessage().setHeader("CamelOffset", (Object)Resumables.of((Object)(body + ".txt"), (Object)num));
        }
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.bindToRegistry("testResumeStrategy", new TransientResumeStrategy((ResumeAdapter)FileConsumerResumeStrategyTest.this.adapter));
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from(FileConsumerResumeStrategyTest.this.fileUri("resume?noop=true&recursive=true")).resumable("testResumeStrategy")).process(e -> FileConsumerResumeStrategyTest.this.setOffset(e))).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }

    private static class TestFileSetResumeAdapter
    implements FileResumeAdapter,
    DirectoryEntriesResumeAdapter {
        private final List<String> processedFiles = Arrays.asList("0.txt", "1.txt", "2.txt");
        private boolean resumedCalled;

        private TestFileSetResumeAdapter() {
        }

        public void resume() {
        }

        public boolean resume(File file) {
            this.resumedCalled = true;
            return this.processedFiles.contains(file.getName());
        }
    }
}

