/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.consumer.DirectoryEntriesResumeAdapter;
import org.apache.camel.component.file.consumer.FileOffsetResumeAdapter;
import org.apache.camel.component.file.consumer.FileResumeAdapter;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ResumableDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.resume.TransientResumeStrategy;
import org.apache.camel.resume.ResumeAdapter;
import org.apache.camel.support.resume.Resumables;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisabledOnOs(architectures={"s390x"}, disabledReason="This test does not run reliably on s390x (see CAMEL-21438)")
public class FileConsumerResumeFromOffsetStrategyTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(FileConsumerResumeFromOffsetStrategyTest.class);
    private static final TransientResumeStrategy FAIL_RESUME_STRATEGY = new TransientResumeStrategy((ResumeAdapter)new FailResumeAdapter());

    @DisplayName(value="Tests whether it can resume from an offset")
    @Test
    public void testResumeFromOffset() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"34567890"});
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CamelFileName", "resume-from-offset.txt");
        headers.put("CamelOffset", (String)Resumables.of((Object)"resume-from-offset.txt", (Object)3L));
        this.template.sendBodyAndHeaders(this.fileUri("resumeOff"), (Object)"01234567890", headers);
        this.assertMockEndpointsSatisfied();
    }

    @DisplayName(value="Tests whether it a missing offset causes a failure")
    @Test
    public void testMissingOffset() throws InterruptedException {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"34567890"});
        mock.expectedMessageCount(2);
        this.template.sendBodyAndHeader(this.fileUri("resumeMissingOffset"), (Object)"01234567890", "CamelFileName", (Object)"resume-from-offset.txt");
        MockEndpoint.assertWait((long)2L, (TimeUnit)TimeUnit.SECONDS, (MockEndpoint[])new MockEndpoint[]{mock});
        List exchangeList = mock.getExchanges();
        Assertions.assertFalse((boolean)exchangeList.isEmpty(), (String)"It should have received a few messages");
    }

    @DisplayName(value="Tests whether it a missing offset does not cause a failure when using intermittent mode")
    @Test
    public void testMissingOffsetWithIntermittentMode() throws InterruptedException {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"01234567890"});
        this.template.sendBodyAndHeader(this.fileUri("resumeMissingOffsetIntermittent"), (Object)"01234567890", "CamelFileName", (Object)"resume-from-offset.txt");
        this.assertMockEndpointsSatisfied();
        List exchangeList = mock.getExchanges();
        Assertions.assertFalse((boolean)exchangeList.isEmpty(), (String)"It should have received a few messages");
    }

    @DisplayName(value="Tests whether we can start from the beginning (i.e.: no resume strategy)")
    @Test
    public void testNoResume() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"01234567890"});
        this.template.sendBodyAndHeader(this.fileUri("resumeNone"), (Object)"01234567890", "CamelFileName", (Object)"resume-none.txt");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.bindToRegistry("myResumeStrategy", new TransientResumeStrategy((ResumeAdapter)new TestFileResumeAdapter()));
                this.bindToRegistry("resumeNotToBeCalledStrategy", FAIL_RESUME_STRATEGY);
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from(FileConsumerResumeFromOffsetStrategyTest.this.fileUri("resumeOff?noop=true&recursive=true")).resumable("myResumeStrategy")).setHeader("CamelOffset", (Expression)this.constant(Resumables.of((Object)"resume-none.txt", (Object)3)))).log("${body}")).convertBodyTo(String.class)).to("mock:result");
                ((ResumableDefinition)((ResumableDefinition)this.from(FileConsumerResumeFromOffsetStrategyTest.this.fileUri("resumeMissingOffset?noop=true&recursive=true")).resumable().resumeStrategy("resumeNotToBeCalledStrategy").log("${body}")).convertBodyTo(String.class)).to("mock:result");
                ((ResumableDefinition)((ResumableDefinition)this.from(FileConsumerResumeFromOffsetStrategyTest.this.fileUri("resumeMissingOffsetIntermittent?noop=true&recursive=true")).resumable().resumeStrategy("resumeNotToBeCalledStrategy").intermittent(true).log("${body}")).convertBodyTo(String.class)).to("mock:result");
                ((RouteDefinition)this.from(FileConsumerResumeFromOffsetStrategyTest.this.fileUri("resumeNone?noop=true&recursive=true")).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }

    private static class FailResumeAdapter
    implements FileResumeAdapter,
    DirectoryEntriesResumeAdapter {
        private FailResumeAdapter() {
        }

        public void resume() {
        }

        public boolean resume(File file) {
            return false;
        }
    }

    private static class TestFileResumeAdapter
    implements FileResumeAdapter,
    FileOffsetResumeAdapter {
        private GenericFile<File> resumable;

        private TestFileResumeAdapter() {
        }

        public void setResumePayload(GenericFile<File> resumable) {
            if (!((File)resumable.getFile()).getName().startsWith("resume-from-offset")) {
                throw new RuntimeCamelException("Invalid file - resume strategy should not have been called!");
            }
            this.resumable = resumable;
        }

        public void resume() {
            if (this.resumable != null) {
                this.resumable.updateLastOffsetValue(Long.valueOf(3L));
                this.resumable = null;
            }
        }
    }
}

