/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
public class FileConsumerRestartNotLeakThreadTest
extends ContextTestSupport {
    @Test
    public void testLeak() throws Exception {
        int before = Thread.activeCount();
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        for (int i = 0; i < 50; ++i) {
            this.context.getRouteController().stopRoute("foo");
            this.context.getRouteController().startRoute("foo");
        }
        this.resetMocks();
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        this.assertMockEndpointsSatisfied();
        int active = Thread.activeCount() - before;
        this.log.info("Active threads after restarts: {}", (Object)active);
        Assertions.assertTrue((active < 10 ? 1 : 0) != 0, (String)("There should not be so many active threads, was " + active));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from(FileConsumerRestartNotLeakThreadTest.this.fileUri()).routeId("foo").to("mock:foo");
            }
        };
    }
}

