/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.junit.jupiter.api.Test;

public class FileConsumerRelativeFileNameTest
extends ContextTestSupport {
    @Test
    public void testValidFilenameOnExchange() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        ((MockValueBuilder)mock.allMessages().header("CamelFileName")).isNotNull();
        this.template.sendBodyAndHeader(this.fileUri("filename-consumer"), (Object)"Hello World", "CamelFileName", (Object)this.testFile("filename-consumer-hello.txt").getFileName().toString());
        this.template.sendBodyAndHeader(this.fileUri("filename-consumer"), (Object)"Bye World", "CamelFileName", (Object)this.testFile("filename-consumer-bye.txt").getFileName().toString());
        this.context.getRouteController().startAllRoutes();
        this.assertMockEndpointsSatisfied();
        FileConsumerRelativeFileNameTest.assertDirectoryEquals(this.testFile("filename-consumer-bye.txt").getFileName().toString(), (String)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getHeader("CamelFileName", String.class));
        FileConsumerRelativeFileNameTest.assertDirectoryEquals(this.testFile("filename-consumer-hello.txt").getFileName().toString(), (String)((Exchange)mock.getReceivedExchanges().get(1)).getIn().getHeader("CamelFileName", String.class));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from(FileConsumerRelativeFileNameTest.this.fileUri("filename-consumer?initialDelay=0&delay=10&recursive=true&sortBy=file:name")).autoStartup(false).to("mock:result");
            }
        };
    }
}

