/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileConsumerPreMoveLastModifiedTest
extends ContextTestSupport {
    @Test
    public void testPreMoveLastModified() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from(FileConsumerPreMoveLastModifiedTest.this.fileUri("?preMove=work/work-${file:name}&initialDelay=0&delay=10&keepLastModified=true")).process((Processor)new LastModifiedCheckerProcessor())).log("Got file ${file:name} modified=${file:modified}")).to("mock:result");
            }
        };
    }

    private static class LastModifiedCheckerProcessor
    implements Processor {
        private LastModifiedCheckerProcessor() {
        }

        public void process(Exchange exchange) {
            Assertions.assertTrue(((Long)exchange.getIn().getHeader("CamelFileLastModified", Long.class) > 0L ? 1 : 0) != 0);
            Assertions.assertTrue(((Long)exchange.getIn().getHeader("CamelFileLength", Long.class) > 0L ? 1 : 0) != 0);
        }
    }
}

