/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileConsumerPreMoveIssueTest
extends ContextTestSupport {
    @Test
    public void testPreMove() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        this.context.getRegistry().bind("testDirectory", (Object)this.testDirectory());
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumerPreMoveIssueTest.this.fileUri("?preMove=before/${file:name.noext}-moved.${file:ext}&initialDelay=0&delay=10")).process((Processor)new MyPreMoveCheckerProcessor())).to("mock:result");
            }
        };
    }

    public static class MyPreMoveCheckerProcessor
    implements Processor {
        public void process(Exchange exchange) {
            Path testDirectory = (Path)exchange.getContext().getRegistry().lookupByName("testDirectory");
            Path file = testDirectory.resolve("before/hello-moved.txt");
            Assertions.assertTrue((boolean)Files.exists(file, new LinkOption[0]), (String)"Pre move file should exist");
        }
    }
}

