/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileConsumerPreMoveDeleteTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME = "hello." + String.valueOf(UUID.randomUUID()) + ".txt";

    @Test
    public void testPreMoveDelete() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesWaitTime();
        Assertions.assertFalse((boolean)Files.exists(this.testFile("work/" + TEST_FILE_NAME), new LinkOption[0]), (String)"Pre move file should have been deleted");
    }

    @Test
    public void testPreMoveDeleteSameFileTwice() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesWaitTime();
        mock.reset();
        this.oneExchangeDone.reset();
        mock.expectedBodiesReceived(new Object[]{"Hello Again World"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello Again World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesWaitTime();
        Assertions.assertFalse((boolean)Files.exists(this.testFile("work/" + TEST_FILE_NAME), new LinkOption[0]), (String)"Pre move file should have been deleted");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumerPreMoveDeleteTest.this.fileUri("?preMove=work&delete=true&idempotent=false&initialDelay=0&delay=10")).process((Processor)new MyPreMoveCheckerProcessor())).to("mock:result");
            }
        };
    }

    public class MyPreMoveCheckerProcessor
    implements Processor {
        public void process(Exchange exchange) {
            Assertions.assertTrue((boolean)Files.exists(FileConsumerPreMoveDeleteTest.this.testFile("work/" + TEST_FILE_NAME), new LinkOption[0]), (String)"Pre move file should exist");
        }
    }
}

