/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.time.Duration;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.spi.Registry;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;

@DisabledIfSystemProperty(named="ci.env.name", matches="github.com", disabledReason="Flaky on Github CI")
public class FileConsumerPollStrategyStopOnRollbackTest
extends ContextTestSupport {
    private static int counter;
    private static volatile String event;

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myPoll", (Object)new MyPollStrategy());
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumerPollStrategyStopOnRollbackTest.this.fileUri("?pollStrategy=#myPoll&initialDelay=0&delay=10")).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }

    @Test
    public void testStopOnRollback() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        mock.assertIsSatisfied(50L);
        Awaitility.await().atMost(Duration.ofSeconds(5L)).untilAsserted(() -> Assertions.assertEquals((Object)"rollback", (Object)event));
    }

    static {
        event = "";
    }

    private static class MyPollStrategy
    implements PollingConsumerPollStrategy {
        private MyPollStrategy() {
        }

        public boolean begin(Consumer consumer, Endpoint endpoint) {
            try {
                consumer.start();
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
            }
            if (counter++ == 0) {
                throw new IllegalArgumentException("Damn I cannot do this");
            }
            return true;
        }

        public void commit(Consumer consumer, Endpoint endpoint, int polledMessages) {
            event = event + "commit";
        }

        public boolean rollback(Consumer consumer, Endpoint endpoint, int retryCounter, Exception cause) {
            if (cause.getMessage().equals("Damn I cannot do this")) {
                event = event + "rollback";
                consumer.stop();
            }
            return false;
        }
    }
}

