/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.spi.Registry;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileConsumerPollStrategyRollbackThrowExceptionTest
extends ContextTestSupport {
    private static volatile String event = "";
    private static final CountDownLatch LATCH = new CountDownLatch(1);

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myPoll", (Object)new MyPollStrategy());
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumerPollStrategyRollbackThrowExceptionTest.this.fileUri("?pollStrategy=#myPoll&initialDelay=0&delay=10")).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }

    @Test
    public void testRollbackThrowException() {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        Awaitility.await().atMost(2L, TimeUnit.SECONDS).until(() -> LATCH.getCount() == 0L);
        Assertions.assertTrue((boolean)event.startsWith("rollback"));
    }

    private static class MyPollStrategy
    implements PollingConsumerPollStrategy {
        private MyPollStrategy() {
        }

        public boolean begin(Consumer consumer, Endpoint endpoint) {
            throw new IllegalArgumentException("Damn I cannot do this");
        }

        public void commit(Consumer consumer, Endpoint endpoint, int polledMessages) {
            event = event + "commit";
        }

        public boolean rollback(Consumer consumer, Endpoint endpoint, int retryCounter, Exception cause) throws Exception {
            event = event + "rollback";
            LATCH.countDown();
            throw cause;
        }
    }
}

