/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileConsumerNoopTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME_1 = "hello" + String.valueOf(UUID.randomUUID()) + ".txt";
    private static final String TEST_FILE_NAME_2 = "bye" + String.valueOf(UUID.randomUUID()) + ".txt";

    @Test
    public void testNoop() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME_1);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Bye World", "CamelFileName", (Object)TEST_FILE_NAME_2);
        this.assertMockEndpointsSatisfied();
        Assertions.assertTrue((boolean)Files.exists(this.testFile(TEST_FILE_NAME_1), new LinkOption[0]));
        Assertions.assertTrue((boolean)Files.exists(this.testFile(TEST_FILE_NAME_2), new LinkOption[0]));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumerNoopTest.this.fileUri("?noop=true&initialDelay=0&delay=10")).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

