/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.OnCompletionDefinition;
import org.junit.jupiter.api.Test;

public class FileConsumerMoveFailureOnCompletionTest
extends ContextTestSupport {
    @Test
    public void testMoveFailedRollbackOnly() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        mock.expectedFileExists(this.testFile("error/bye-error.txt"), "Kaboom");
        this.getMockEndpoint("mock:failed").expectedMessageCount(1);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Kaboom", "CamelFileName", (Object)"bye.txt");
        mock.assertIsSatisfied(1000L);
    }

    @Test
    public void testMoveFailedCommitAndFailure() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedFileExists(this.testFile(".camel/hello.txt"), "Hello World");
        mock.expectedFileExists(this.testFile("error/bye-error.txt"), "Kaboom");
        this.getMockEndpoint("mock:failed").expectedMessageCount(1);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Kaboom", "CamelFileName", (Object)"bye.txt");
        mock.assertIsSatisfied(1000L);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((OnCompletionDefinition)this.from(FileConsumerMoveFailureOnCompletionTest.this.fileUri("?initialDelay=0&delay=10&moveFailed=error/${file:name.noext}-error.txt")).onCompletion().onFailureOnly().to("mock:failed")).end().process(new Processor(){

                    public void process(Exchange exchange) {
                        String body = (String)exchange.getIn().getBody(String.class);
                        if ("Kaboom".equals(body)) {
                            throw new IllegalArgumentException("Forced");
                        }
                    }
                }).convertBodyTo(String.class).to("mock:result");
            }
        };
    }
}

