/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.language.bean.BeanExpression;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileConsumerMoveExpressionTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myguidgenerator", (Object)new MyGuidGenerator());
        return jndi;
    }

    @Test
    public void testRenameToId() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumerMoveExpressionTest.this.fileUri("?initialDelay=0&delay=10&exclude=.*bak&move=${id}.bak")).convertBodyTo(String.class)).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"report.txt");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesWaitTime();
        String id = ((Exchange)mock.getExchanges().get(0)).getIn().getMessageId();
        Assertions.assertTrue((boolean)Files.exists(this.testFile(id + ".bak"), new LinkOption[0]), (String)"File should have been renamed");
    }

    @Test
    public void testRenameToComplexWithId() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumerMoveExpressionTest.this.fileUri("?initialDelay=0&delay=10&exclude=.*bak&move=backup-${id}-${file:name.noext}.bak")).convertBodyTo(String.class)).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Bye World", "CamelFileName", (Object)"report2.txt");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesWaitTime();
        String id = ((Exchange)mock.getExchanges().get(0)).getIn().getMessageId();
        Assertions.assertTrue((boolean)Files.exists(this.testFile("backup-" + id + "-report2.bak"), new LinkOption[0]), (String)"File should have been renamed");
    }

    @Test
    public void testRenameToBean() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumerMoveExpressionTest.this.fileUri("?initialDelay=0&delay=10&exclude=.*bak&move=backup/${bean:myguidgenerator.guid}.txt")).convertBodyTo(String.class)).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye Big World"});
        mock.expectedFileExists(this.testFile("backup/123.txt"), "Bye Big World");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Bye Big World", "CamelFileName", (Object)"report3.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRenameToSiblingFolder() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from(FileConsumerMoveExpressionTest.this.fileUri("test?initialDelay=0&delay=10&exclude=.*bak&move=../backup/${file:name}.bak")).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello Big World"});
        mock.expectedFileExists(this.testFile("backup/report4.txt.bak"));
        this.template.sendBodyAndHeader(this.fileUri("test"), (Object)"Hello Big World", "CamelFileName", (Object)"report4.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRenameToBeanWithBeanLanguage() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                FileEndpoint endpoint = new FileEndpoint();
                endpoint.setCamelContext((CamelContext)FileConsumerMoveExpressionTest.this.context);
                endpoint.setFile(FileConsumerMoveExpressionTest.this.testDirectory().toFile());
                endpoint.setAutoCreate(false);
                endpoint.setMove((Expression)new BeanExpression("myguidgenerator", null));
                endpoint.setExclude(".*bak");
                endpoint.setInitialDelay(10L);
                this.from((Endpoint)endpoint).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bean Language Rules The World"});
        mock.expectedFileExists(this.testFile("123"));
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Bean Language Rules The World", "CamelFileName", (Object)"report5.txt");
        this.assertMockEndpointsSatisfied();
    }

    public static class MyGuidGenerator {
        public String guid() {
            return "123";
        }
    }
}

