/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileConsumerInterceptEmptyFileTest
extends ContextTestSupport {
    @Test
    public void testExcludeZeroLengthFiles() throws Exception {
        MockEndpoint mock1 = this.getMockEndpoint("mock:result");
        mock1.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World", "Bye World"});
        MockEndpoint mock2 = this.getMockEndpoint("mock:skip");
        mock2.expectedMessageCount(2);
        this.sendFiles();
        this.assertMockEndpointsSatisfied();
    }

    private void sendFiles() {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"hello.xml");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"", "CamelFileName", (Object)"empty1.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Bye World", "CamelFileName", (Object)"secret.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"", "CamelFileName", (Object)"empty2.txt");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((InterceptDefinition)this.interceptFrom().onWhen((Predicate)this.simple("${file:length} == 0")).to("mock:skip")).stop();
                ((RouteDefinition)((RouteDefinition)this.from(FileConsumerInterceptEmptyFileTest.this.fileUri("?initialDelay=10&delay=10")).convertBodyTo(String.class)).to("log:test")).to("mock:result");
            }
        };
    }
}

