/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileConsumerIncludeNameTest
extends ContextTestSupport {
    @Test
    public void testIncludePreAndPostfixes() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Reports1", "Reports2", "Reports3"});
        mock.expectedMessageCount(3);
        this.sendFiles();
        mock.assertIsSatisfied();
    }

    private void sendFiles() {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"hello.xml");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Reports1", "CamelFileName", (Object)"report1.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Bye World", "CamelFileName", (Object)"secret.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Reports2", "CamelFileName", (Object)"report2.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Reports3", "CamelFileName", (Object)"Report3.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Secret2", "CamelFileName", (Object)"Secret2.txt");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumerIncludeNameTest.this.fileUri("?initialDelay=0&delay=10&include=^report.*txt$")).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

