/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Test;

public class FileConsumerIncludeExtTest
extends ContextTestSupport {
    @Test
    public void testFileConsumer() throws Exception {
        this.getMockEndpoint("mock:txt").expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World", "123", "Bye World"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"<customer>123</customer>", "CamelFileName", (Object)"customer.xml");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"123", "CamelFileName", (Object)"order.DAT");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"<book>Camel Rocks</book>", "CamelFileName", (Object)"book.xml");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from(FileConsumerIncludeExtTest.this.fileUri("?initialDelay=0&delay=10&includeExt=txt,dat")).to("mock:txt");
            }
        };
    }
}

