/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileConsumerIncludeAndExcludeNameTest
extends ContextTestSupport {
    @Test
    public void testIncludePreAndPostfixes() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Report 2", "Report 3", "Report 4"});
        mock.expectedMessageCount(3);
        this.sendFiles();
        mock.assertIsSatisfied();
    }

    private void sendFiles() {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Report 1", "CamelFileName", (Object)"report1.xml");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Report 2", "CamelFileName", (Object)"report2.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Report 3", "CamelFileName", (Object)"report3.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Report 4", "CamelFileName", (Object)"Report4.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Secret", "CamelFileName", (Object)"Secret.txt");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumerIncludeAndExcludeNameTest.this.fileUri("?initialDelay=0&delay=10&include=report.*txt&exclude=hello.*")).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

