/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.processor.idempotent.MemoryIdempotentRepository;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileConsumerIdempotentTest
extends ContextTestSupport {
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumerIdempotentTest.this.fileUri("?idempotent=true&move=done/${file:name}&initialDelay=0&delay=10")).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }

    @Test
    public void testIdempotent() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"report.txt");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesWaitTime();
        mock.reset();
        mock.expectedMessageCount(0);
        Files.move(this.testFile("done/report.txt"), this.testFile("report.txt"), new CopyOption[0]);
        Awaitility.await().pollDelay(100L, TimeUnit.MILLISECONDS).untilAsserted(() -> this.assertMockEndpointsSatisfied());
        FileEndpoint fe = (FileEndpoint)this.context.getEndpoint(this.fileUri(), FileEndpoint.class);
        Assertions.assertNotNull((Object)fe);
        MemoryIdempotentRepository repo = (MemoryIdempotentRepository)fe.getInProgressRepository();
        Assertions.assertEquals((int)0, (int)repo.getCacheSize(), (String)"Should be no in-progress files");
    }
}

