/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.Registry;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileConsumerIdempotentRefTest
extends ContextTestSupport {
    private static volatile boolean invoked;

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myRepo", (Object)new MyIdempotentRepository());
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumerIdempotentRefTest.this.fileUri("?idempotent=true&idempotentRepository=#myRepo&move=done/${file:name}&initialDelay=0&delay=10")).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }

    @Test
    public void testIdempotentRef() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"report.txt");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedMessageCount(1);
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesWaitTime();
        mock.reset();
        mock.expectedMessageCount(0);
        Files.move(this.testFile("done/report.txt"), this.testFile("report.txt"), new CopyOption[0]);
        Awaitility.await().pollDelay(100L, TimeUnit.MILLISECONDS).untilAsserted(() -> this.assertMockEndpointsSatisfied());
        Assertions.assertTrue((boolean)invoked, (String)"MyIdempotentRepository should have been invoked");
    }

    public class MyIdempotentRepository
    implements IdempotentRepository {
        public boolean add(String messageId) {
            boolean result = invoked;
            invoked = true;
            Assertions.assertEquals((Object)FileConsumerIdempotentRefTest.this.testFile("report.txt").toAbsolutePath().toString(), (Object)messageId);
            return !result;
        }

        public boolean contains(String key) {
            return invoked;
        }

        public boolean remove(String key) {
            return true;
        }

        public boolean confirm(String key) {
            return true;
        }

        public void clear() {
        }

        public void start() {
        }

        public void stop() {
        }
    }
}

