/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.UUID;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileConsumerIdempotentOnExceptionHandledTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME = "hello" + String.valueOf(UUID.randomUUID()) + ".txt";

    @Test
    public void testIdempotent() throws Exception {
        this.getMockEndpoint("mock:invalid").expectedMessageCount(1);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.oneExchangeDone.matchesWaitTime();
        this.assertMockEndpointsSatisfied();
        FileConsumerIdempotentOnExceptionHandledTest.assertFileNotExists(this.testFile(TEST_FILE_NAME));
        FileConsumerIdempotentOnExceptionHandledTest.assertFileExists(this.testFile(".camel/" + TEST_FILE_NAME));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.onException(Exception.class).handled(true).to("mock:invalid");
                ((RouteDefinition)this.from(FileConsumerIdempotentOnExceptionHandledTest.this.fileUri("?initialDelay=0&delay=10&idempotent=true")).to("mock:input")).throwException((Exception)new IllegalArgumentException("Forced"));
            }
        };
    }
}

