/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.FileConsumerIdempotentTest;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;

@DisabledIfSystemProperty(named="ci.env.name", matches="github.com", disabledReason="Flaky on Github CI")
public class FileConsumerIdempotentKeyNameAndSizeTest
extends FileConsumerIdempotentTest {
    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumerIdempotentKeyNameAndSizeTest.this.fileUri("?idempotent=true&idempotentKey=${file:onlyname}-${file:size}&move=done/${file:name}&initialDelay=0&delay=10")).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }

    @Test
    public void testIdempotentDiffSize() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"report.txt");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesWaitTime();
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Bye World", "CamelFileName", (Object)"report.txt");
        this.assertMockEndpointsSatisfied();
    }
}

