/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileConsumerIdempotentKeyChangedIssueTest
extends ContextTestSupport {
    private static final String TEST_FILE_NAME = "hello" + String.valueOf(UUID.randomUUID()) + ".txt";
    private Endpoint endpoint;

    @Test
    public void testFile() throws Exception {
        this.getMockEndpoint("mock:file").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader(this.endpoint, (Object)"Hello World", "CamelFileName", (Object)TEST_FILE_NAME);
        this.context.getRouteController().startAllRoutes();
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matches(5L, TimeUnit.SECONDS);
        this.resetMocks();
        this.getMockEndpoint("mock:file").expectedBodiesReceived(new Object[]{"Hello World Again"});
        this.template.sendBodyAndHeader(this.endpoint, (Object)"Hello World Again", "CamelFileName", (Object)TEST_FILE_NAME);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                FileConsumerIdempotentKeyChangedIssueTest.this.endpoint = this.endpoint(FileConsumerIdempotentKeyChangedIssueTest.this.fileUri("?noop=true&readLock=changed&initialDelay=0&delay=10&readLockCheckInterval=100&idempotentKey=${file:onlyname}-${file:size}-${date:file:yyyyMMddHHmmss}"));
                ((RouteDefinition)((RouteDefinition)this.from(FileConsumerIdempotentKeyChangedIssueTest.this.endpoint).autoStartup(false).convertBodyTo(String.class)).to("log:file")).to("mock:file");
            }
        };
    }
}

