/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;

@DisabledOnOs(architectures={"s390x"}, disabledReason="This test does not run reliably on s390x (see CAMEL-21438)")
public class FileConsumerFilterFileTest
extends ContextTestSupport {
    public static final String FILE_URL_1 = "?initialDelay=0&delay=10&filterFile=${bodyAs(String)} contains 'World'";
    public static final String FILE_URL_2 = "?initialDelay=0&delay=10&filterFile=${file:modified} < ${date:now-2s}";

    @Test
    public void testFilterFiles() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"This is a file to be filtered", "CamelFileName", (Object)"skipme.txt");
        mock.setResultWaitTime(100L);
        mock.assertIsSatisfied();
    }

    @Test
    public void testFilterFilesWithARegularFile() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"This is a file to be filtered", "CamelFileName", (Object)"skipme2.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        mock.assertIsSatisfied();
    }

    @Test
    public void testFilterFilesWithDate() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result2");
        mock.expectedBodiesReceived(new Object[]{"Something else"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Something else", "CamelFileName", (Object)"hello2.txt");
        mock.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumerFilterFileTest.this.fileUri(FileConsumerFilterFileTest.FILE_URL_1)).convertBodyTo(String.class)).to("mock:result");
                ((RouteDefinition)this.from(FileConsumerFilterFileTest.this.fileUri(FileConsumerFilterFileTest.FILE_URL_2)).convertBodyTo(String.class)).to("mock:result2");
            }
        };
    }
}

