/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class FileConsumerFilterDirectoryTest
extends ContextTestSupport {
    @Test
    public void testFilterFiles() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        this.template.sendBodyAndHeader(this.fileUri("foo"), (Object)"This is a file to be filtered", "CamelFileName", (Object)"skipme.txt");
        mock.setResultWaitTime(100L);
        mock.assertIsSatisfied();
    }

    @Test
    public void testFilterFilesWithARegularFile() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader(this.fileUri("foo"), (Object)"This is a file to be filtered", "CamelFileName", (Object)"skipme.txt");
        this.template.sendBodyAndHeader(this.fileUri("barbar"), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        mock.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumerFilterDirectoryTest.this.fileUri("?initialDelay=0&delay=10&recursive=true&filterDirectory=${header.CamelFileNameOnly.length()} > 4")).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

