/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Test;

public class FileConsumerFileNameFilterTest
extends ContextTestSupport {
    @Test
    public void testFileConsumer() throws Exception {
        MockEndpoint mockEndpoint = this.getMockEndpoint("mock:txt");
        mockEndpoint.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World", "Bye World"});
        String fileUri = this.fileUri();
        this.template.sendBodyAndHeader(fileUri, (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.template.sendBodyAndHeader(fileUri, (Object)"<customer>123</customer>", "CamelFileName", (Object)"customer.xml");
        this.template.sendBodyAndHeader(fileUri, (Object)"<book>Camel Rocks</book>", "CamelFileName", (Object)"book.xml");
        this.template.sendBodyAndHeader(fileUri, (Object)"Bye World", "CamelFileName", (Object)"bye.txt");
        this.context.getRouteController().startAllRoutes();
        mockEndpoint.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from(FileConsumerFileNameFilterTest.this.fileUri("?initialDelay=0&delay=10&fileName=${file:onlyname.noext}.txt")).autoStartup(false).to("mock:txt");
            }
        };
    }
}

