/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileFilter;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;

public class FileConsumerFileFilterTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("myFilter", new MyFileFilter());
        return jndi;
    }

    @Test
    public void testFilterFiles() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"This is a file to be filtered", "CamelFileName", (Object)"skipme.txt");
        mock.setResultWaitTime(100L);
        mock.assertIsSatisfied();
    }

    @Test
    public void testFilterFilesWithARegularFile() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"This is a file to be filtered", "CamelFileName", (Object)"skipme.txt");
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        mock.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumerFileFilterTest.this.fileUri("?initialDelay=0&delay=10&filter=#myFilter")).convertBodyTo(String.class)).to("mock:result");
            }
        };
    }

    public static class MyFileFilter<T>
    implements GenericFileFilter<T> {
        public boolean accept(GenericFile<T> file) {
            if (file.isDirectory()) {
                return true;
            }
            return !file.getFileName().startsWith("skip");
        }
    }
}

