/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.spi.Registry;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileConsumerFileExpressionThrowExceptionTest
extends ContextTestSupport {
    private static volatile String event = "";
    private static volatile Exception rollbackCause;
    private static final CountDownLatch LATCH;

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("counter", (Object)new MyGuidGenerator());
        jndi.bind("myPoll", (Object)new MyPollStrategy());
        return jndi;
    }

    @Test
    public void testConsumeExpressionThrowException() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri("bean"), (Object)"Bye World", "CamelFileName", (Object)"123.txt");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from(FileConsumerFileExpressionThrowExceptionTest.this.fileUri("bean?pollStrategy=#myPoll&initialDelay=0&delay=10&fileName=${bean:counter?method=next}.txt&delete=true")).to("mock:result");
            }
        });
        Awaitility.await().atMost(2L, TimeUnit.SECONDS).until(() -> LATCH.getCount() == 0L);
        Assertions.assertTrue((boolean)event.startsWith("rollback"));
        Assertions.assertNotNull((Object)rollbackCause);
        IllegalArgumentException e = FileConsumerFileExpressionThrowExceptionTest.assertIsInstanceOf(IllegalArgumentException.class, rollbackCause.getCause());
        Assertions.assertNotNull((Object)e);
        Assertions.assertEquals((Object)"Forced", (Object)e.getMessage());
    }

    static {
        LATCH = new CountDownLatch(1);
    }

    public static class MyGuidGenerator {
        public String next() {
            throw new IllegalArgumentException("Forced");
        }
    }

    private static class MyPollStrategy
    implements PollingConsumerPollStrategy {
        private MyPollStrategy() {
        }

        public boolean begin(Consumer consumer, Endpoint endpoint) {
            return true;
        }

        public void commit(Consumer consumer, Endpoint endpoint, int polledMessages) {
            event = event + "commit";
        }

        public boolean rollback(Consumer consumer, Endpoint endpoint, int retryCounter, Exception cause) {
            event = event + "rollback";
            rollbackCause = cause;
            LATCH.countDown();
            return false;
        }
    }
}

