/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Test;

public class FileConsumerFileExpressionTest
extends ContextTestSupport {
    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("counter", (Object)new MyGuidGenerator());
        return jndi;
    }

    @Test
    public void testConsumeFileBasedOnBeanName() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri("bean"), (Object)"Hello World", "CamelFileName", (Object)"122.txt");
        this.template.sendBodyAndHeader(this.fileUri("bean"), (Object)"Goodday World", "CamelFileName", (Object)"123.txt");
        this.template.sendBodyAndHeader(this.fileUri("bean"), (Object)"Bye World", "CamelFileName", (Object)"124.txt");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from(FileConsumerFileExpressionTest.this.fileUri("bean?initialDelay=0&delay=10&fileName=${bean:counter.next}.txt&delete=true")).to("mock:result");
            }
        });
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Goodday World"});
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConsumeFileBasedOnDatePattern() throws Exception {
        this.template.sendBodyAndHeader(this.fileUri("date"), (Object)"Bye World", "CamelFileName", (Object)"myfile-20081128.txt");
        this.template.sendBodyAndHeader(this.fileUri("date"), (Object)"Hello World", "CamelFileName", (Object)"myfile-20081129.txt");
        this.template.sendBodyAndHeader(this.fileUri("date"), (Object)"Goodday World", "CamelFileName", (Object)this.context.resolveLanguage("simple").createExpression("myfile-${date:now:yyyyMMdd}.txt"));
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(FileConsumerFileExpressionTest.this.fileUri("date?initialDelay=0&delay=10&fileName=myfile-${date:now:yyyyMMdd}.txt")).convertBodyTo(String.class)).to("mock:result");
            }
        });
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Goodday World"});
        this.assertMockEndpointsSatisfied();
    }

    public static class MyGuidGenerator {
        public String next() {
            return "123";
        }
    }
}

