/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.ValidationException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileConsumerFailureHandledTest
extends ContextTestSupport {
    @Test
    public void testParis() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:valid");
        mock.expectedBodiesReceived(new Object[]{"Hello Paris"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Paris", "CamelFileName", (Object)"paris.txt");
        mock.assertIsSatisfied(2000L);
        this.oneExchangeDone.matchesWaitTime();
        this.assertFiles("paris.txt", true);
    }

    @Test
    public void testLondon() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:invalid");
        mock.expectedBodiesReceived(new Object[]{"London"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"London", "CamelFileName", (Object)"london.txt");
        mock.assertIsSatisfied(2000L);
        this.oneExchangeDone.matchesWaitTime();
        this.assertFiles("london.txt", true);
    }

    @Test
    public void testDublin() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:beer");
        mock.expectedBodiesReceived(new Object[]{"Dublin"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Dublin", "CamelFileName", (Object)"dublin.txt");
        mock.assertIsSatisfied(2000L);
        this.oneExchangeDone.matchesWaitTime();
        this.assertFiles("dublin.txt", false);
    }

    @Test
    public void testMadrid() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:error");
        mock.expectedBodiesReceived(new Object[]{"Madrid"});
        this.template.sendBodyAndHeader(this.fileUri(), (Object)"Madrid", "CamelFileName", (Object)"madrid.txt");
        mock.assertIsSatisfied(2000L);
        this.oneExchangeDone.matchesWaitTime();
        this.assertFiles("madrid.txt", true);
    }

    private void assertFiles(String filename, boolean deleted) {
        Path file = this.testFile(filename);
        Assertions.assertEquals((Object)deleted, (Object)(!Files.exists(file, new LinkOption[0]) ? 1 : 0), (String)("File " + filename + " should be deleted: " + deleted));
        String lock = filename + ".camelLock";
        file = this.testFile(lock);
        Assertions.assertFalse((boolean)Files.exists(file, new LinkOption[0]), (String)("File " + lock + " should be deleted"));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error").maximumRedeliveries(2).redeliveryDelay(0L).logStackTrace(false));
                this.onException(ValidationException.class).onWhen(this.exceptionMessage().contains((Object)"beer")).handled(false).to("mock:beer");
                this.onException(ValidationException.class).handled(true).to("mock:invalid");
                ((RouteDefinition)this.from(FileConsumerFailureHandledTest.this.fileUri("?initialDelay=0&delay=10&delete=true")).process((Processor)new MyValidatorProcessor())).to("mock:valid");
            }
        };
    }

    private static class MyValidatorProcessor
    implements Processor {
        private MyValidatorProcessor() {
        }

        public void process(Exchange exchange) throws Exception {
            String body = (String)exchange.getIn().getBody(String.class);
            if ("London".equals(body)) {
                throw new ValidationException(exchange, "Forced exception by unit test");
            }
            if ("Madrid".equals(body)) {
                throw new RuntimeCamelException("Madrid is not a supported city");
            }
            if ("Dublin".equals(body)) {
                throw new ValidationException(exchange, "Dublin have good beer");
            }
            exchange.getMessage().setBody((Object)("Hello " + body));
        }
    }
}

